*_______________________
*
* 1. Theoretical Model
*_______________________
use BLrep_data.dta

nbreg fadopt L4.ComSubmission EC10 EC12 EC15 EC25 ANT1981 ANT1986 ANT1995 ANT2004 PostSEA PostTEU PostAMS PostNICE Delors jun dec if date <= 572, robust

estat ic

* Make predictions, obtain CIs, and compute goodness of prediction measures
predict yhat

gen suemod=(fadopt-yhat)^2  // Residuals

gen suenaiv=(fadopt-L. fadopt)^2 // Subtracts the value y_t-1 from y_t

egen ssuemod=total(suemod) if date >=573 & date <=584
quietly su ssuemod
local num=r(mean)

egen ssuenaiv=total(suenaiv) if date >=573 & date <=584
quietly su ssuenaiv
local den=r(mean)

local U=sqrt(`num'/`den') 
display `U'

* Mean squared prediction error
su suemod
local MSPE=r(mean)
display `MSPE'
save 01_rep.dta, replace

clear

* Out-of sample forecast
* Use extended dataset 
use 01_rep_ext.dta
nbreg fadopt cs_ori_pred EC10 EC12 EC15 EC25 EC27 ANT1981 ANT1986 ANT1995  ANT2004 ANT2007 PostSEA PostTEU PostAMS PostNICE Delors jun dec if date <= 584, robust
predict dl_os_fc
label variable dl_os_fc "TM forecast"
keep date dl_os_fc
save dl_os_fc.dta, replace
